/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.brush;

import java.awt.Rectangle;
import java.awt.geom.Area;
import tiled.core.TileLayer;
import tiled.mapeditor.brush.AbstractBrush;
import tiled.mapeditor.brush.ShapeBrush;
import tiled.util.MersenneTwister;

public class RandomBrush
extends ShapeBrush {
    private final MersenneTwister mt = new MersenneTwister(System.currentTimeMillis());
    private double ratio = 0.5;

    public RandomBrush(Area shape) {
        super(shape);
    }

    public RandomBrush(AbstractBrush sb) {
        super(sb);
        if (sb instanceof RandomBrush) {
            this.ratio = ((RandomBrush)sb).ratio;
        }
    }

    public void setRatio(double r) {
        this.ratio = r;
    }

    public double getRatio() {
        return this.ratio;
    }

    @Override
    public Rectangle doPaint(int x, int y) {
        Rectangle shapeBounds = this.shape.getBounds();
        int centerx = x - shapeBounds.width / 2;
        int centery = y - shapeBounds.height / 2;
        for (int i = 0; i < this.numLayers; ++i) {
            TileLayer tl = (TileLayer)this.affectedMp.getLayer(this.initLayer - i);
            if (tl == null) continue;
            for (int cy = 0; cy <= shapeBounds.height; ++cy) {
                for (int cx = 0; cx < shapeBounds.width; ++cx) {
                    if (!this.shape.contains(cx, cy) || !((double)(this.mt.genrand() % 101L) <= 100.0 * this.ratio)) continue;
                    tl.setTileAt(cx + centerx, cy + centery, this.paintTile);
                }
            }
        }
        return new Rectangle(centerx, centery, shapeBounds.width, shapeBounds.height);
    }
}

